/*
Copyright ＿ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/

var gDefaultCity = 8;
var gDefaultContinent = 5;
var gDefaultLocale = "San Francisco";
var SouthAmerica = [
	{city:'Asuncion', offset:-240, timezone:'America/Asuncion'},
	{city:'Bogota', offset:-300, timezone:'America/Bogota'},
	{city:'Brasalia', offset:-180, timezone:'Brazil/East'},
	{city:'Buenos Aires', offset:-180, timezone:'America/Buenos_Aires'},
	{city:'Caracas', offset:-240, timezone:'America/Caracas'},
	{city:'Cayenne', offset:-180, timezone:'America/Cayenne'},
	{city:'Georgetown', offset:-240, timezone:'America/Guyana'},
	{city:'La Paz', offset:-240, timezone:'America/La_Paz'},
	{city:'Lima', offset:-300, timezone:'America/Lima'},
	{city:'Montevideo', offset:-180, timezone:'America/Montevideo'},
	{city:'Paramaribo', offset:-180, timezone:'America/Paramaribo'},
	{city:'Quito', offset:-300, timezone:'America/Guayaquil'},
	{city:'Recife', offset:-180, timezone:'America/Recife'},
	{city:'Rio de Janeiro', offset:-180, timezone:'Brazil/East'},
	{city:'San Juan', offset:-240, timezone:'America/Puerto_Rico'},
	{city:'Santiago', offset:-240, timezone:'America/Santiago'},
	{city:'Sao Paulo', offset:-180, timezone:'America/Sao_Paulo'}
];
var Pacific = [
	{city:'Guam', offset:600, timezone:'Pacific/Guam'},
	{city:'Honolulu', offset:-600, timezone:'Pacific/Honolulu'},
	{city:'Noumea', offset:660, timezone:'Pacific/Noumea'},
	{city:'Pago Pago', offset:-660, timezone:'Pacific/Pago_Pago'},
	{city:'Wellington', offset:720, timezone:'Pacific/Auckland'}
];
var Atlantic = [
	{city:'Grytviken', offset:-120, timezone:'Atlantic/South_Georgia'},
	{city:'Ponta Delgada', offset:0, timezone:'Atlantic/Azores'},
	{city:'Reykjavik', offset:0, timezone:'Atlantic/Reykjavik'}
];
var Europe = [
	{city:'Amsterdam', offset:120, timezone:'Europe/Amsterdam'},
	{city:'Athens', offset:180, timezone:'Europe/Athens'},
	{city:'Belgrade', offset:180, timezone:'Europe/Belgrade'},
	{city:'Berlin', offset:120, timezone:'Europe/Berlin'},
	{city:'Brussels', offset:120, timezone:'Europe/Brussels'},
	{city:'Bucharest', offset:180, timezone:'Europe/Bucharest'},
	{city:'Budapest', offset:120, timezone:'Europe/Budapest'},
	{city:'Cardiff', offset:60, timezone:'Europe/London'},
	{city:'Copenhagen', offset:120, timezone:'Europe/Copenhagen'},
	{city:'Cork', offset:60, timezone:'Europe/Dublin'},
	{city:'Dublin', offset:60, timezone:'Europe/Dublin'},
	{city:'Edinburgh', offset:60, timezone:'Europe/London'},
	{city:'Geneva', offset:120, timezone:'Europe/Zurich'},
	{city:'Helsinki', offset:180, timezone:'Europe/Helsinki'},
	{city:'Istanbul', offset:180, timezone:'Asia/Istanbul'},
	{city:'Kiev', offset:180, timezone:'Europe/Kiev'},
	{city:'Lisbon', offset:60, timezone:'Europe/Lisbon'},
	{city:'Ljubljana', offset:120, timezone:'Europe/Ljubljana'},
	{city:'London', offset:60, timezone:'Europe/London'},
	{city:'Madrid', offset:120, timezone:'Europe/Madrid'},
	{city:'Moscow', offset:240, timezone:'Europe/Moscow'},
	{city:'Munich', offset:120, timezone:'Europe/Berlin'},
	{city:'Oslo', offset:120, timezone:'Europe/Oslo'},
	{city:'Paris', offset:120, timezone:'Europe/Paris'},
	{city:'Prague', offset:120, timezone:'Europe/Prague'},
	{city:'Rome', offset:120, timezone:'Europe/Rome'},
	{city:'Sofia', offset:180, timezone:'Europe/Sofia'},
	{city:'St. Petersburg', offset:240, timezone:'Europe/Moscow'},
	{city:'Stockholm', offset:120, timezone:'Europe/Stockholm'},
	{city:'Vienna', offset:120, timezone:'Europe/Vienna'},
	{city:'Volgograd', offset:240, timezone:'Europe/Moscow'},
	{city:'Warsaw', offset:120, timezone:'Europe/Warsaw'},
	{city:'Zagreb', offset:120, timezone:'Europe/Zagreb'},
	{city:'Zurich', offset:120, timezone:'Europe/Zurich'}
];
var Africa = [
	{city:'Accra', offset:0, timezone:'Africa/Accra'},
	{city:'Addis Ababa', offset:180, timezone:'Africa/Addis_Ababa'},
	{city:'Algiers', offset:60, timezone:'Africa/Algiers'},
	{city:'Asmera', offset:180, timezone:'Africa/Asmera'},
	{city:'Bamako', offset:0, timezone:'Africa/Bamako'},
	{city:'Bangui', offset:60, timezone:'Africa/Bangui'},
	{city:'Cairo', offset:180, timezone:'Africa/Cairo'},
	{city:'Cape Town', offset:120, timezone:'Africa/Johannesburg'},
	{city:'Conakry', offset:0, timezone:'Africa/Conakry'},
	{city:'Dakar', offset:0, timezone:'Africa/Dakar'},
	{city:'Dar es Salaam', offset:180, timezone:'Africa/Dar_es_Salaam'},
	{city:'Djibouti', offset:180, timezone:'Africa/Djibouti'},
	{city:'Douala', offset:60, timezone:'Africa/Douala'},
	{city:'Freetown', offset:0, timezone:'Africa/Freetown'},
	{city:'Harare', offset:120, timezone:'Africa/Harare'},
	{city:'Kampala', offset:180, timezone:'Africa/Kampala'},
	{city:'Khartoum', offset:180, timezone:'Africa/Khartoum'},
	{city:'Kinshasa', offset:60, timezone:'Africa/Kinshasa'},
	{city:'Lagos', offset:60, timezone:'Africa/Lagos'},
	{city:'Luanda', offset:60, timezone:'Africa/Luanda'},
	{city:'Lusaka', offset:120, timezone:'Africa/Lusaka'},
	{city:'Maputo', offset:120, timezone:'Africa/Maputo'},
	{city:'Mogadishu', offset:180, timezone:'Africa/Mogadishu'},
	{city:'Monrovia', offset:0, timezone:'Africa/Monrovia'},
	{city:'Nairobi', offset:180, timezone:'Africa/Nairobi'},
	{city:'Ndjamena', offset:60, timezone:'Africa/Ndjamena'},
	{city:'Nouakchott', offset:0, timezone:'Africa/Nouakchott'},
	{city:'Ouagadougou', offset:0, timezone:'Africa/Ouagadougou'},
	{city:'Rabat', offset:0, timezone:'Africa/Casablanca'},
	{city:'Tripoli', offset:120, timezone:'Africa/Tripoli'},
	{city:'Tunis', offset:60, timezone:'Africa/Tunis'}
];
var NorthAmerica = [
	{city:'Adak', offset:-540, timezone:'America/Adak'},
	{city:'Anchorage', offset:-480, timezone:'America/Anchorage'},
	{city:'Atlanta', offset:-240, timezone:'US/Eastern'},
	{city:'Austin', offset:-300, timezone:'US/Central'},
	{city:'Boston', offset:-240, timezone:'US/Eastern'},
	{city:'Calgary', offset:-360, timezone:'Canada/Mountain'},
	{city:'Chicago', offset:-300, timezone:'America/Chicago'},
	{city:'Columbus', offset:-240, timezone:'US/Eastern'},
	{city:'Cupertino', offset:-420, timezone:'US/Pacific'},
	{city:'Dallas', offset:-300, timezone:'US/Central'},
	{city:'Denver', offset:-360, timezone:'America/Denver'},
	{city:'Detroit', offset:-240, timezone:'America/Detroit'},
	{city:'Guatemala', offset:-360, timezone:'America/Guatemala'},
	{city:'Halifax', offset:-180, timezone:'Canada/Atlantic'},
	{city:'Havana', offset:-240, timezone:'America/Havana'},
	{city:'Indianapolis', offset:-300, timezone:'America/Indianapolis'},
	{city:'Knoxville', offset:-240, timezone:'US/Eastern'},
	{city:'Los Angeles', offset:-420, timezone:'America/Los_Angeles'},
	{city:'Managua', offset:-360, timezone:'America/Managua'},
	{city:'Manchester', offset:-240, timezone:'US/Eastern'},
	{city:'Memphis', offset:-300, timezone:'US/Central'},
	{city:'Mexico City', offset:-300, timezone:'America/Mexico_City'},
	{city:'Miami', offset:-240, timezone:'US/Eastern'},
	{city:'Minneapolis', offset:-300, timezone:'US/Central'},
	{city:'Montreal', offset:-240, timezone:'America/Montreal'},
	{city:'New York', offset:-240, timezone:'America/New_York'},
	{city:'Nuuk', offset:-120, timezone:'America/Godthab'},
	{city:'Ottawa', offset:-240, timezone:'Canada/Eastern'},
	{city:'Panama', offset:-300, timezone:'America/Panama'},
	{city:'Philadelphia', offset:-240, timezone:'US/Eastern'},
	{city:'Phoenix', offset:-420, timezone:'America/Phoenix'},
	{city:'Port-au-Prince', offset:-300, timezone:'America/Port-au-Prince'},
	{city:'Portland', offset:-420, timezone:'US/Pacific'},
	{city:'Regina', offset:-360, timezone:'Canada/Saskatchewan'},
	{city:'Salt Lake City', offset:-360, timezone:'US/Mountain'},
	{city:'San Diego', offset:-420, timezone:'US/Pacific'},
	{city:'San Francisco', offset:-420, timezone:'US/Pacific'},
	{city:'San Jose', offset:-360, timezone:'America/Costa_Rica'},
	{city:'San Salvador', offset:-360, timezone:'America/El_Salvador'},
	{city:'Santo Domingo', offset:-240, timezone:'America/Santo_Domingo'},
	{city:'Seattle', offset:-420, timezone:'US/Pacific'},
	{city:'St. John\'s', offset:-150, timezone:'Canada/Newfoundland'},
	{city:'St. Louis', offset:-300, timezone:'US/Central'},
	{city:'Tegucigalpa', offset:-360, timezone:'America/Tegucigalpa'},
	{city:'Toronto', offset:-240, timezone:'Canada/Eastern'},
	{city:'Vancouver', offset:-420, timezone:'America/Vancouver'},
	{city:'Washington, D.C.', offset:-240, timezone:'US/Eastern'},
	{city:'Winnipeg', offset:-300, timezone:'America/Winnipeg'}
];
var Asia = [
	{city:'Abu Dhabi', offset:240, timezone:'Asia/Dubai'},
	{city:'Amman', offset:180, timezone:'Asia/Amman'},
	{city:'Anadyr', offset:780, timezone:'Asia/Anadyr'},
	{city:'Ankara', offset:180, timezone:'Europe/Istanbul'},
	{city:'Antananarivo', offset:180, timezone:'Indian/Antananarivo'},
	{city:'Baghdad', offset:240, timezone:'Asia/Baghdad'},
	{city:'Bangkok', offset:420, timezone:'Asia/Bangkok'},
	{city:'Beijing', offset:480, timezone:'Asia/Shanghai'},
	{city:'Beirut', offset:180, timezone:'Asia/Beirut'},
	{city:'Canton', offset:480, timezone:'Asia/Shanghai'},
	{city:'Chennai (Madras)', offset:330, timezone:'Asia/Calcutta'},
	{city:'Colombo', offset:360, timezone:'Asia/Colombo'},
	{city:'Dhaka', offset:360, timezone:'Asia/Dhaka'},
	{city:'Damascus', offset:180, timezone:'Asia/Damascus'},
	{city:'Doha', offset:180, timezone:'Asia/Qatar'},
	{city:'Hanoi', offset:420, timezone:'Asia/Saigon'},
	{city:'Hong Kong', offset:480, timezone:'Asia/Hong_Kong'},
	{city:'Islamabad', offset:300, timezone:'Asia/Karachi'},
	{city:'Jakarta', offset:420, timezone:'Asia/Jakarta'},
	{city:'Jerusalem', offset:180, timezone:'Asia/Jerusalem'},
	{city:'Kabul', offset:270, timezone:'Asia/Kabul'},
	{city:'Katmandu', offset:345, timezone:'Asia/Katmandu'},
	{city:'Kolkata (Calcutta)', offset:330, timezone:'Asia/Calcutta'},
	{city:'Krasnoyarsk', offset:480, timezone:'Asia/Krasnoyarsk'},
	{city:'Kuala Lumpur', offset:480, timezone:'Asia/Kuala_Lumpur'},
	{city:'Kuwait', offset:180, timezone:'Asia/Kuwait'},
	{city:'Magadan', offset:720, timezone:'Asia/Magadan'},
	{city:'Male', offset:300, timezone:'Indian/Maldives'},
	{city:'Manama', offset:180, timezone:'Asia/Bahrain'},
	{city:'Manila', offset:480, timezone:'Asia/Manila'},
	{city:'Mecca', offset:180, timezone:'Asia/Riyadh'},
	{city:'Mumbai (Bombay)', offset:330, timezone:'Asia/Calcutta'},
	{city:'Muscat', offset:240, timezone:'Asia/Muscat'},
	{city:'New Delhi', offset:330, timezone:'Asia/Calcutta'},
	{city:'Novosibirsk', offset:420, timezone:'Asia/Novosibirsk'},
	{city:'Omsk', offset:420, timezone:'Asia/Omsk'},
	{city:'Osaka', offset:540, timezone:'Asia/Tokyo'},
	{city:'Phnom Penh', offset:420, timezone:'Asia/Phnom_Penh'},
	{city:'Port Louis', offset:240, timezone:'Indian/Mauritius'},
	{city:'Pyongyang', offset:540, timezone:'Asia/Pyongyang'},
	{city:'Rangoon', offset:390, timezone:'Asia/Rangoon'},
	{city:'Riyadh', offset:180, timezone:'Asia/Riyadh'},
	{city:'Sanaa', offset:180, timezone:'Asia/Aden'},
	{city:'Seoul', offset:540, timezone:'Asia/Seoul'},
	{city:'Shanghai', offset:480, timezone:'Asia/Shanghai'},
	{city:'Singapore', offset:480, timezone:'Asia/Singapore'},
	{city:'Taipei', offset:480, timezone:'Asia/Taipei'},
	{city:'Tashkent', offset:300, timezone:'Asia/Tashkent'},
	{city:'Tehran', offset:270, timezone:'Asia/Tehran'},
	{city:'Thanh Pho Ho Chi Minh', offset:420, timezone:'Asia/Saigon'},
	{city:'Tientsin', offset:480, timezone:'Asia/Shanghai'},
	{city:'Tokyo', offset:540, timezone:'Japan'},
	{city:'Ulaanbaatar', offset:480, timezone:'Asia/Ulaanbaatar'},
	{city:'Victoria', offset:240, timezone:'Indian/Mahe'},
	{city:'Vladivostok', offset:660, timezone:'Asia/Vladivostok'},
	{city:'Yakutsk', offset:600, timezone:'Asia/Yakutsk'},
	{city:'Yekaterinburg', offset:360, timezone:'Asia/Yekaterinburg'}
];
var Australia = [
	{city:'Adelaide', offset:570, timezone:'Australia/Adelaide'},
	{city:'Brisbane', offset:600, timezone:'Australia/Brisbane'},
	{city:'Canberra', offset:600, timezone:'Australia/Canberra'},
	{city:'Darwin', offset:570, timezone:'Australia/Darwin'},
	{city:'Hobart', offset:600, timezone:'Australia/Hobart'},
	{city:'Melbourne', offset:600, timezone:'Australia/Melbourne'},
	{city:'Perth', offset:480, timezone:'Australia/Perth'},
	{city:'Sydney', offset:600, timezone:'Australia/Sydney'}
];

var continents = [
	{name:"Africa", array:Africa},
	{name:"Asia", array:Asia},
	{name:"Atlantic", array:Atlantic},
	{name:"Australia", array:Australia},
	{name:"Europe", array:Europe},
	{name:"North America", array:NorthAmerica},
	{name:"Pacific", array:Pacific},
	{name:"South America", array:SouthAmerica}
];

var kNoSweepbackMask = 0x01;
var kNoFaceAnimationMask = 0x02;

//==========================================================
//  Constants that control second hand "sproing" animation
//==========================================================
//  To simulate a mechanical second hand motion, we will:
//    - Go to T+n
//    - Go to T-n
//    - Go to T+(n/2)
//    - Go to T-(n/2)
//    - Go to T+(n/4)
//    - Go to T-(n/4)
//    - Go to T
var secondsSweepbackAnimateInterval = 35;
var secondsSweepbackMax = 0.15;
var secondsSweepbackAmounts = new Array( -2*secondsSweepbackMax, 1.5*secondsSweepbackMax,
										 -secondsSweepbackMax, 0.75*secondsSweepbackMax,
										 -0.5*secondsSweepbackMax, 0.25*secondsSweepbackMax );
var secondSweepbackAnimation = {step:0, timer:null, originalSeconds:0};

// vars needed for hand spin animation
var spinHandsAnimation = {preAnimationDelay:800, incrementDelay:15, displayedTime:{hours:0, minutes:0, seconds:0}, targetTime:{hours:0, minutes:0, seconds:0}, forwards:true, minutesDifference:0, minutesPassed:0, incrementMin:1, incrementMax:6, incrementCurrent:.5, rampUpPeriod:30, rampDownPeriod:60};

var clockFaceAnimation = {duration:450, starttime:0, to:1.0, now:0.0, from:0.0, element:null, timer:null};

var clockTimerInterval = null;

var currentTimezone;
var minutesAngle;
var hoursAngle;
var secondsAngle;

function createKey(key) {
	if (window.widget) {
        key = widget.identifier + "-" + key;
	}
	return key;
}

function setInstanceAndGlobalPreferenceForKey(value, key) {
	setInstancePreferenceForKey(value, key);
	setGlobalPreferenceForKey(value, key);
}

function setInstancePreferenceForKey(value, key) {
	setGlobalPreferenceForKey(value, createKey(key));
}

function setGlobalPreferenceForKey(value, key) {
	if (window.widget) {
		widget.setPreferenceForKey(value, key);
	}
}

function preferenceForKey(key) {
	var result;
	if (window.widget) {
		result = widget.preferenceForKey(createKey(key));
		if (!result) {
			result = widget.preferenceForKey(key);
		}
	}
	if (!result) {
		result = eval("gDefault" + key.substring(0,1).toUpperCase() + key.substring(1));
	}
	return result;
}

var kContinentIndexKey = "continent";
var kCityIndexKey = "city";
var kLocaleKey = "locale";

function onshow() {
	if (clockTimerInterval == null) {
		startClockTimer();
	}
	updateTime(null,kNoSweepbackMask|kNoFaceAnimationMask);
}

function onhide() {
	stopClockTimer();
	clearHands();
}

function onsync() {
	loadPreferences();
	startClockTimer();
	// TODO call this instead???
	//onshow();
}

function onremove() {
	setInstancePreferenceForKey(null, kContinentIndexKey);
	setInstancePreferenceForKey(null, kCityIndexKey);
}

function savePreferences() {
	setInstanceAndGlobalPreferenceForKey(gDefaultContinent.toString(), kContinentIndexKey);
	setInstanceAndGlobalPreferenceForKey(gDefaultCity.toString(), kCityIndexKey);
}

if (window.widget) {
	data = preferenceForKey(kLocaleKey);
	widget.onhide = onhide;
	widget.onshow = onshow;
	widget.onremove = onremove;
	widget.onsync = onsync;
}

function $(id) {
	return document.getElementById(id);
}

function load() {
	loadPreferences();
	
	var doneButton = $('done');
	new AppleGlassButton (doneButton, getLocalizedString('Done'), doneClicked);	 	
	new AppleInfoButton($("infoButton"), $("front"), "white", "white", showbackside);
	
	startClockTimer();
}

function loadPreferences() {
	updateDefaultCityAndContinent();
	gDefaultCity = parseInt(preferenceForKey(kCityIndexKey));
	gDefaultContinent = parseInt(preferenceForKey(kContinentIndexKey));
		
	// Save orig GMT offset
	currentTimezone = continents[gDefaultContinent].array[gDefaultCity].timezone;
	
	populateContinentSelect();
 	$ ('continent-popup').options[gDefaultContinent].selected = true;
	popuplateCitySelect(continents[gDefaultContinent].array);
 	$ ('city-popup').options[gDefaultCity].selected = true;
 	$('localeDisplay').innerText= getLocalizedCityName(continents[gDefaultContinent].array[gDefaultCity].city);
 	
 	$('continent-label').innerText = getLocalizedString('Continent:');
 	$('city-label').innerText = getLocalizedString('City:');
 	$('ampm').innerText = getLocalizedString(isItAM ? 'AM' : 'PM');
	savePreferences();
}

function getLocalizedString (key)
{
    try {
            var ret = localizedStrings[key];
            if (ret === undefined)
                    ret = key;
            return ret;
    } catch (ex) {}

    return key;
}

function getLocalizedCityName (key)
{
    try {
            var ret = localizedCityNames[key];
            if (ret === undefined)
                    ret = key;
            return ret;
    } catch (ex) {}

    return key;
}

function getLocalizedContinentName (key)
{
    try {
            var ret = localizedContinentNames[key];
            if (ret === undefined)
                    ret = key;
            return ret;
    } catch (ex) {}

    return key;
}

function updateDefaultCityAndContinent()
{
	// reset defaults to cupertino, north america
	gDefaultCity = 8;
	gDefaultContinent = 5;

	if (window.TimeZoneInfo) {
		var continentName = TimeZoneInfo.getDefaultContinentName();
		var count = continents.length;
				
		for(i = 0; i < count; i++)
		{
			if (continentName == continents[i].name)
			{
				gDefaultContinent = i;
				break;
			}
		}
		
		// if we're not in north america, default to first city in time zone
		if (continentName != "North America")
			gDefaultCity = 0;
		
		// get city
		cityName = TimeZoneInfo.getDefaultCityName();

		// find city in array
		var cityArray = continents[gDefaultContinent].array;
		count = cityArray.length;
		for(i = 0; i < count; i++)
		{
			if (cityName == cityArray[i].city)
			{
				gDefaultCity = i;
				break;
			}
		}
			
	}
	
	// Save orig GMT offset
	currentTimezone = continents[gDefaultContinent].array[gDefaultCity].timezone;
}

var isItEvening = isEvening((new Date).getHours());
var isItAM = isAM ((new Date).getHours);

function isEvening (hours)
{
	return hours < 6 || hours > 17;
}

function isAM (hours)
{
	return hours < 12;
}

imageLoaded.numImages = 5;
imageLoaded.count = 0;

function imageLoaded(evt) {
	imageLoaded.count++;
	if (imageLoaded.numImages == imageLoaded.count) {
		onshow();
	}
}

// Preload both sets of images
var minhand;
var minhand_pm = new Image (17, 53);
minhand_pm.src = 'Images/pmmins.pdf';
minhand_pm.onload = imageLoaded;
var minhand_am = new Image (17, 53);
minhand_am.src = 'Images/mins.pdf';
minhand_am.onload = imageLoaded;

if (isItEvening)
	minhand = minhand_pm;
else
	minhand = minhand_am;


var hourhand;
var hourhand_pm = new Image (13, 27);
hourhand_pm.src = 'Images/pmhour.pdf';
hourhand_pm.onload = imageLoaded;
var hourhand_am = new Image (13, 27);
hourhand_am.src = 'Images/hour.pdf';
hourhand_am.onload = imageLoaded;

if (isItEvening)
	hourhand = hourhand_pm;
else
	hourhand = hourhand_am;
		
var sechand = new Image (7, 55);
sechand.src = 'Images/secs.pdf';
sechand.onload = imageLoaded;

function secondSweepbackAnimate()
{
	if (secondSweepbackAnimation.step >= secondsSweepbackAmounts.length)
	{
		//  no more steps to the animation, clear the timer
		clearInterval(secondSweepbackAnimation.timer);
		secondSweepbackAnimation.timer = null;
		secondSweepbackAnimation.step = 0;
	}
	else
	{
		secondSweepbackAnimation.originalSeconds = secondSweepbackAnimation.originalSeconds + secondsSweepbackAmounts[secondSweepbackAnimation.step];
		secondsAngle = secondSweepbackAnimation.originalSeconds * 0.10471975511965977; // all angles computed in radians
		
		drawHands (hoursAngle, minutesAngle, secondsAngle);
		
		secondSweepbackAnimation.step++;
	}
}


// The time encoding from the plugin stores the hours minutes and seconds in an int as hhmmss
function getHoursMinutesSeconds(encodedTime)
{
	var parts = new Array();
	
	// Decode hours
	parts.hours = parseInt(encodedTime/10000);
	
	// Grab remainder
	var afterHours = encodedTime%10000;
	
	// Minutes is remainder div 100
	parts.minutes = parseInt(afterHours/100);
	
	// Seconds is the remainder of that
	parts.seconds = afterHours%100;
	
	return parts;
}

function updateTime(newTime,flags)
{
	var hours,minutes,seconds,evening,am;
	
	var shouldDoSweepback = ((flags & kNoSweepbackMask) == 0);
	var shouldAnimateFaceChange = ((flags & kNoFaceAnimationMask) == 0);
	
	if (newTime) {
		// time is specified during tz change animation
		hours = newTime.hours;
		minutes = newTime.minutes;
		seconds = newTime.seconds;
		
		// Keep the global current
		spinHandsAnimation.displayedTime = newTime;
	}
	else if (window.TimeZoneInfo && currentTimezone) {
		var encodedTime = TimeZoneInfo.currentTimeForTimeZone(currentTimezone);
		
		// Keep the globals current
		var timeParts = getHoursMinutesSeconds(encodedTime);
		hours = timeParts.hours;
		minutes = timeParts.minutes;
		seconds = timeParts.seconds;
	}	
	else {	
		// Fall back to offset
		var now = new Date();
		var ourGMTOffset = now.getTimezoneOffset();
		var targetGMTOffset = continents[gDefaultContinent].array[gDefaultCity].offset;
		
		now.setTime(now.getTime() + ((ourGMTOffset + targetGMTOffset) * 60 * 1000));
		hours = now.getHours();
		minutes = now.getMinutes();
		seconds = now.getSeconds();
	}
	
	evening = isEvening(hours);
	am = isAM(hours);

	//
	// change the face if necessary.  if no sweepback and not in spin anim, don't animate face change either.
	//
	if (evening != isItEvening)
	{
		isItEvening = evening;
		var eveningElement = $('eveningFace');
			
		if (evening)
		{
			hourhand = hourhand_pm;
			minhand = minhand_pm;
			if (shouldAnimateFaceChange) {
				clockFaceAnimation.to = 1.0;
			}
			else {
				eveningElement.style.opacity = 1.0;
			}
		}
		else
		{
			hourhand = hourhand_am;
			minhand = minhand_am;
			if (shouldAnimateFaceChange) {
				clockFaceAnimation.to = 0.0;
			}
			else {
				eveningElement.style.opacity = 0.0;
			}
		}
		
		// Perform clock face animation if necessary
		if (shouldAnimateFaceChange) {
			// set animation state for face change
			if (clockFaceAnimation.timer != null)
			{
				clearInterval (clockFaceAnimation.timer);
				clockFaceAnimation.timer  = null;
			}
			
			var starttime = (new Date).getTime() - 13; // set it back one frame
			clockFaceAnimation.starttime = starttime;
			clockFaceAnimation.element = eveningElement;
			clockFaceAnimation.now = parseFloat(eveningElement.style.opacity);
			clockFaceAnimation.from = clockFaceAnimation.now;
			clockFaceAnimation.timer = setInterval ("animate(clockFaceAnimation);", 35);
			
			animate(clockFaceAnimation);
		}
	}
	
	if (am != isItAM)
	{
		isItAM = am;
	 	$('ampm').innerText = getLocalizedString(isItAM ? 'AM' : 'PM');
	}

	secondSweepbackAnimation.originalSeconds = seconds+secondsSweepbackMax;
	var secondsAngle = secondSweepbackAnimation.originalSeconds * 0.10471975511965977; // all angles computed in radians
	minutesAngle = minutes * 0.10471975511965977;
	hoursAngle = ((hours%12) * 0.523598775598) + (minutesAngle/6.283185481853 * 0.523598775598);

	drawHands (hoursAngle, minutesAngle, secondsAngle);

	if (shouldDoSweepback)
	{
		if (secondSweepbackAnimation.timer != null)
		{
			clearInterval(secondSweepbackAnimation.timer);
			secondSweepbackAnimation.timer = null;
		}
		secondSweepbackAnimation.step = 0;
		secondSweepbackAnimation.timer = setInterval("secondSweepbackAnimate();", secondsSweepbackAnimateInterval);
	}
}

function startClockTimer()
{
	stopClockTimer();
	clockTimerInterval = setInterval("updateTime(null,null);", 1000);
}

function stopClockTimer()
{
	if (clockTimerInterval != null)
	{
		clearInterval(clockTimerInterval);
		clockTimerInterval = null;
	}
}

function resetHandSpinAnimation()
{
	// Reset the globals
	spinHandsAnimation.displayedTime.hours = 0;
	spinHandsAnimation.displayedTime.minutes = 0;
	spinHandsAnimation.displayedTime.seconds = 0;
	spinHandsAnimation.targetTime.hours = 0;
	spinHandsAnimation.targetTime.minutes = 0;
	spinHandsAnimation.targetTime.seconds = 0;
	spinHandsAnimation.minutesPassed = 0;
	spinHandsAnimation.minutesDifference = 0;
	
	newGMTOffset = null;
	origGMTOffset = null;
}

function clearHands()
{
	var canvas = $("canvas");
	var context = canvas.getContext("2d");
	
	context.clearRect (0, 0, 112, 112);
}

function drawHands (hoursAngle, minutesAngle, secondsAngle)
{	
	if (imageLoaded.count < imageLoaded.numImages)
		return;
	var canvas =    $("canvas");
	var context = canvas.getContext("2d");

	context.clearRect (0, 0, 112, 112);

	context.save();
	context.translate (112/2, 112/2 -1);

	context.save();
	context.rotate (-hoursAngle);
	context.translate (-7, -28.5);
	context.drawImage (hourhand, 0, 0, 13, 27);
	context.restore();

	context.save();
	context.rotate (-minutesAngle);
	context.translate (-8.5, -44);
	context.drawImage (minhand, 0, 0, 17, 53);
	context.restore();

	context.rotate (-secondsAngle);
	context.translate (-3.5, -50.5);
	context.drawImage (sechand, 0, 0, 7, 55);

	context.restore();

//  context.setFillColor ("black");
//  context.fillRect(112/2, 0, 1, 112);
//  context.fillRect(0, (112/2)-1, 112, 1);
}

function showbackside(event)
{
	var front = $("front");
	var back = $("behind");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	
	stopClockTimer();
	resetHandSpinAnimation();
	
	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);	

}


function doneClicked() {
	var front = $("front");
	var back = $("behind");

	if (window.widget)
			widget.prepareForTransition("ToFront");

	front.style.display="block";
	back.style.display="none";
	
	// on delay so hands can show during flip
	setTimeout ('flipitback();', 0);
}

function flipitback()
{	
	if (window.widget)
			setTimeout("widget.performTransition();", 0);
	
	// Right now we're displaying the current time in the old timezone.
    
	// Get the newly selected timezone
	var newTimezone = continents[gDefaultContinent].array[gDefaultCity].timezone;
	var oldTimezone = currentTimezone;
	
	// Set current to new tz
	currentTimezone = newTimezone;
	
	// the currently displayed time
	spinHandsAnimation.displayedTime = getHoursMinutesSeconds(TimeZoneInfo.currentTimeForTimeZone(oldTimezone));
	
	// Time showing on face as we flip back
	updateTime(spinHandsAnimation.displayedTime,kNoSweepbackMask|kNoFaceAnimationMask);
	
	// the time we'll animate to
	spinHandsAnimation.targetTime = getHoursMinutesSeconds(TimeZoneInfo.currentTimeForTimeZone(newTimezone));

	// Get the offsets from gmt
	var origGMTOffset = TimeZoneInfo.getTimezoneOffsetForTimezoneName(oldTimezone);
	var newGMTOffset = TimeZoneInfo.getTimezoneOffsetForTimezoneName(newTimezone);
	
	// See which direction to spin the hands
	//alert("new offset:"+ newGMTOffset  + "old offset:"+origGMTOffset);
	spinHandsAnimation.forwards = (newGMTOffset > origGMTOffset);
	spinHandsAnimation.minutesDifference = Math.abs(newGMTOffset - origGMTOffset);
	
	// Return immediately if the time is the same
	if (shouldStopSpinning(spinHandsAnimation.displayedTime,spinHandsAnimation.targetTime)) {
		startClockTimer();
		return;
	}
	
	// set up some animation constants
	if (spinHandsAnimation.minutesDifference <= 60) {	// The number of minutes difference between the old and new timezones
		// vals for time changes <= 1 hour
		spinHandsAnimation.incrementMin = .1;	// The bottom of the ease curve (incrementing by 1 minute each frame)
		spinHandsAnimation.incrementMax = 1;	// The top of the ease curve (incrementing by 2 minutes each frame)
		spinHandsAnimation.rampUpPeriod = 10;	// The number of minutes on the clock face over which we ease in
		spinHandsAnimation.rampDownPeriod = 20;	// The number of minutes on the clock face over which we ease out
	}
	else if (spinHandsAnimation.minutesDifference < 480) {
		// vals for time changes < 8 hours
		spinHandsAnimation.incrementMin = .1;
		spinHandsAnimation.incrementMax = 2;
		spinHandsAnimation.rampUpPeriod = 15;
		spinHandsAnimation.rampDownPeriod = 30;
	}
	else {
		spinHandsAnimation.incrementMin = .1;
		spinHandsAnimation.incrementMax = 3;
		spinHandsAnimation.rampUpPeriod = 30;
		spinHandsAnimation.rampDownPeriod = 45;	
	}
	
	// Cancel a running timer.
	if (clockTimerInterval != null)
	{
		clearInterval (clockTimerInterval);
		clockTimerInterval = null;
	}
	
	// Start the spin animation
	setTimeout("clockTimerInterval = setInterval(\"animateHandSpin();\",spinHandsAnimation.incrementDelay)",spinHandsAnimation.preAnimationDelay);
}

function animateHandSpin()
{
	var tmpNewTargetTime = getHoursMinutesSeconds(TimeZoneInfo.currentTimeForTimeZone(currentTimezone));
	if (tmpNewTargetTime.minutes > spinHandsAnimation.targetTime.minutes) {
		if (spinHandsAnimation.forwards)
			spinHandsAnimation.minutesDifference++;
		else
			spinHandsAnimation.minutesDifference--;
	}
	spinHandsAnimation.targetTime = tmpNewTargetTime;
	
	if (shouldStopSpinning(spinHandsAnimation.displayedTime,spinHandsAnimation.targetTime))  // animation is done
	{
		if (clockTimerInterval != null)
		{
			clearInterval (clockTimerInterval);
			clockTimerInterval = null;
			
			resetHandSpinAnimation();
						
			// Start normal clock operation
			updateTime(null,kNoSweepbackMask);
			startClockTimer();
		}
	}
	else  // animate one step
	{	
		var minutesLeft = spinHandsAnimation.minutesDifference - spinHandsAnimation.minutesPassed;
		if (minutesLeft <= spinHandsAnimation.rampDownPeriod) {
			// decel to min speed
			var percentDoneRamp = 1-(minutesLeft/spinHandsAnimation.rampDownPeriod);
			var ease = .5 + .5*Math.cos(Math.PI*percentDoneRamp);
			spinHandsAnimation.currentIncrement = computeNextFloat (spinHandsAnimation.incrementMin, spinHandsAnimation.incrementMax, ease);
		}
		else if (spinHandsAnimation.minutesPassed <= spinHandsAnimation.rampUpPeriod) {
			// accel to top speed
			var percentDoneRamp = spinHandsAnimation.minutesPassed/spinHandsAnimation.rampUpPeriod;
			var ease = .5 - .5*Math.cos(Math.PI*percentDoneRamp);
			spinHandsAnimation.currentIncrement = computeNextFloat (spinHandsAnimation.incrementMin, spinHandsAnimation.incrementMax, ease);
		}
		else {
			spinHandsAnimation.currentIncrement = spinHandsAnimation.incrementMax;
		}
		
		// Make sure this doesn't put us past the end.
		if ((spinHandsAnimation.currentIncrement + spinHandsAnimation.minutesPassed) >= spinHandsAnimation.minutesDifference)
			spinHandsAnimation.currentIncrement = spinHandsAnimation.minutesDifference-spinHandsAnimation.minutesPassed;

		// Update stop counter
		spinHandsAnimation.minutesPassed += spinHandsAnimation.currentIncrement;		

		// Apply directional increment
		spinHandsAnimation.displayedTime = stepHands(spinHandsAnimation.displayedTime,spinHandsAnimation.currentIncrement);
		
		// Keep second hand ticking along.
		spinHandsAnimation.displayedTime.seconds = spinHandsAnimation.targetTime.seconds;
		
		updateTime(spinHandsAnimation.displayedTime,kNoSweepbackMask);
	}
}

// Time passed in hhmmss for as returned by TimeZoneInfo.currentTimeForTimeZone
function shouldStopSpinning(time1,time2)
{
	return (spinHandsAnimation.minutesPassed >= spinHandsAnimation.minutesDifference)
}

// Time comes in as hms array for as returned by TimeZoneInfo.currentTimeForTimeZone
// Assumes stepMinutes is less than an hour.
function stepHands(timeParts,stepMinutes)
{
	if (spinHandsAnimation.forwards)
	{
		if ((timeParts.minutes + stepMinutes) < 60)
			timeParts.minutes += stepMinutes;
		else 
		{
			// Reset mins and add an hour
			timeParts.minutes = timeParts.minutes + stepMinutes - 60;
			if (timeParts.hours < 23)
			{
				// Plus an hour
				timeParts.hours++;
			}
			else
			{
				// Reset hours
				timeParts.hours = 0;
			}
		}
	}
	else
	{
		if ((timeParts.minutes - stepMinutes) >= 0)
			timeParts.minutes -= stepMinutes;
		else 
		{
			// Reset minutes to 59 and subtract an hour
			timeParts.minutes = timeParts.minutes - stepMinutes + 60;
			if (timeParts.hours > 0)
			{
				// Minus an hour
				timeParts.hours--;
			}
			else
			{
				// Reset hours to 23
				timeParts.hours = 23;
			}
		}
	}
	
	return timeParts;
}

//  Returns val if min < val < max
//  Returns min if val <= min
//  Returns max if val >= max
function limit_3 (val, min, max)
{
    return val < min ? min : (val > max ? max : val);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function animate(theAnimation)
{
	var T;
	var ease;
	var time = (new Date).getTime();
	T = limit_3(time-theAnimation.starttime, 0, theAnimation.duration);
	if (T >= theAnimation.duration)
	{
		clearInterval (theAnimation.timer);
		theAnimation.timer = null;
		theAnimation.now = theAnimation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / theAnimation.duration));
		theAnimation.now = computeNextFloat (theAnimation.from, theAnimation.to, ease);
	}
	
	theAnimation.element.style.opacity = theAnimation.now;
}

function populateContinentSelect()
{
	var select = $ ('continent-popup');
	select.innerHTML = "";
	var c = continents.length;
	
	for (var i = 0; i < c; ++i)
	{

		var element = document.createElement("option");
		element.innerText = getLocalizedContinentName(continents[i].name);
		select.appendChild (element);
	}
}

function popuplateCitySelect(cities)
{
	var select = $ ('city-popup');
	select.innerHTML = "";
	var c = cities.length;
	
	for (var i = 0; i < c; ++i)
	{
		var element = document.createElement("option");
		element.innerText = getLocalizedCityName(cities[i].city);
		select.appendChild (element);
	}
}

function continentchanged(select) {
	if (gDefaultContinent != select.selectedIndex) {
		gDefaultContinent = select.selectedIndex;
		popuplateCitySelect(continents[gDefaultContinent].array);
		gDefaultCity = 0;
	 	$ ('city-popup').options[gDefaultCity].selected = true;
	 	$("localeDisplay").innerText= getLocalizedCityName(continents[gDefaultContinent].array[gDefaultCity].city);
	
	 	savePreferences();
	}
}

function citychanged(select) {
	if (gDefaultCity != select.selectedIndex) {
		gDefaultCity = select.selectedIndex;
	 	$("localeDisplay").innerText= getLocalizedCityName(continents[gDefaultContinent].array[gDefaultCity].city);

	 	savePreferences();
	}
}

function debug(msg) {
	if (!debug.box) {
		debug.box = document.createElement("div");
		debug.box.setAttribute("style", "background-color: white; " +
										"font-family: monospace; " +
										"border: solid black 3px; " +
										"position: absolute;top:300px;" +
										"padding: 10px;");
		document.body.appendChild(debug.box);
		debug.box.innerHTML = "<h1 style='text-align:center'>Debug Output</h1>";
	}
	
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	debug.box.appendChild(p);
}

